<?php
/**
 * Copyright © OXID eSales AG. All rights reserved.
 * See LICENSE file for license details.
 */

    // Database connection information
    $this->dbType = 'pdo_mysql';
    $this->dbHost = '<dbHost>'; // database host name
    $this->dbPort  = 3306; // tcp port to which the database is bound
    $this->dbName = '<dbName>'; // database name
    $this->dbUser = '<dbUser>'; // database user name
    $this->dbPwd  = '<dbPwd>'; // database user password
    $this->sShopURL     = '<sShopURL>'; // eShop base url, required
    $this->sSSLShopURL  = null;            // eShop SSL url, optional
    $this->sAdminSSLURL = null;            // eShop Admin SSL url, optional
    $this->sShopDir     = '<sShopDir>';
    $this->sCompileDir  = '<sCompileDir>';

    /**
     * Force shop edition. Even if enterprise or professional packages exists, shop edition can still be forced here.
     * Possible options: CE|PE|EE or left empty (will be determined automatically).
     */
    $this->edition = '';

    // File type whitelist for file upload
    $this->aAllowedUploadTypes = array('jpg', 'gif', 'png', 'pdf', 'mp3', 'avi', 'mpg', 'mpeg', 'doc', 'xls', 'ppt');

    // Timezone information
    date_default_timezone_set('Europe/Berlin');

    /**
     * Search engine friendly URL processor.
     * After changing this value, you should rename oxid.php file as well
     * Always leave .php extension here unless you know what you are doing
     *
     * @deprecated (2018-03-05);
     */
    $this->sOXIDPHP = "oxid.php";

    /**
     * String PSR3 log level Psr\Log\LogLevel
     */
    $this->sLogLevel = 'error';

    /**
     * Log all modifications performed in Admin
     */
    $this->blLogChangesInAdmin = false;

    /**
     * Should requests, coming via stdurl and not redirected to seo url be logged to seologs db table?
     * Note: only active if in productive mode, as the eShop in non productive more will always log such urls
     */
    $this->blSeoLogging = false;

    /**
     * Enable debug mode for template development or bugfixing
     * -1 = Log more messages and throw exceptions on errors (not recommended for production)
     * 0 = off
     * 1 = smarty
     * 3 = smarty
     * 4 = smarty + shoptemplate data
     * 5 = Delivery Cost calculation info
     * 6 = SMTP Debug Messages
     * 8 = display smarty template names (requires /tmp cleanup)
     */
    $this->iDebug = 0;

    /**
     * Should template blocks be highlighted in frontend?
     * This is mainly intended for module writers in non productive environment
     */
    $this->blDebugTemplateBlocks = false;

    // Force admin email. Offline warnings are sent with high priority to this address.
    $this->sAdminEmail = '';

    // Defines the time interval in seconds warnings are sent during the shop is offline.
    $this->offlineWarningInterval = 60 * 5;

    // In case session must be started on the very first user page visit (not only on session required action).
    $this->blForceSessionStart = false;

    // Use browser cookies to store session id (no sid parameter in URL)
    $this->blSessionUseCookies = true;

    /**
     * The domain that the cookie is available: array(_SHOP_ID_ => _DOMAIN_);
     * Check setcookie() documentation for more details: http://php.net/manual/de/function.setcookie.php
     */
    $this->aCookieDomains = null;

    /**
     * The path on the server in which the cookie will be available on: array(_SHOP_ID_ => _PATH_);
     * Check setcookie() documentation for more details: http://php.net/manual/de/function.setcookie.php
     */
    $this->aCookiePaths = null;

    // List of all Search-Engine Robots
    $this->aRobots = array(
                        'googlebot',
                        'ultraseek',
                        'crawl',
                        'spider',
                        'fireball',
                        'robot',
                        'slurp',
                        'fast',
                        'altavista',
                        'teoma',
                        'msnbot',
                        'bingbot',
                        'yandex',
                        'gigabot',
                        'scrubby'
                        );

    // Deactivate Static URL's for these Robots
    $this->aRobotsExcept = array();

    // IP addresses for which session/cookie id match and user agent change checks are off
    $this->aTrustedIPs = array();

    /**
     * Works only if basket reservations feature is enabled in admin.
     *
     * The number specifies how many expired basket reservations are
     * cleaned per one request (to the eShop).
     * Cleaning a reservation basically means returning the reserved
     * stock to the articles.
     *
     * Keeping this number too low may cause article stock being returned too
     * slowly, while too high value may have spiking impact on the performance.
     */
    $this->iBasketReservationCleanPerRequest = 200;

    /**
     * To override FrontendController::$_aUserComponentNames use this array option:
     * array keys are component(class) names and array values defines if component is cacheable (true/false)
     * E.g. array('user_class' => false);
     */
    $this->aUserComponentNames = null;

    // Additional multi language tables
    $this->aMultiLangTables = null;

    // Instructs shop that price update is performed by cron (time based job sheduler)
    $this->blUseCron = false;

    // Do not disable module if class from extension path does not exist.
    $this->blDoNotDisableModuleOnError = false;

    // Enable temporarily in case you can't access the backend due to broken views
    $this->blSkipViewUsage = false;

    /**
     * Enterprise Edition related config options.
     * This options have no effect on Community/Professional Editions.
     */

    //Time limit in ms to be notified about slow queries
    $this->iDebugSlowQueryTime = 20;

    /**
     * Enables Rights and Roles engine
     * 0 - off,
     * 1 - only in admin,
     * 2 - only in shop,
     * 3 - both
     */
    $this->blUseRightsRoles = 3;

    /**
     * Define oxarticles fields which could be edited individually in subshops.
     * Do not forget to add these fields to oxfield2shop table.
     * Note: The field names are case sensitive here.
     */
    $this->aMultishopArticleFields = array("OXPRICE", "OXPRICEA", "OXPRICEB", "OXPRICEC", "OXUPDATEPRICE", "OXUPDATEPRICEA", "OXUPDATEPRICEB", "OXUPDATEPRICEC", "OXUPDATEPRICETIME");

    // Show "Update Views" button in admin
    $this->blShowUpdateViews = true;

    // If default 30 seconds is not enougth
    // @set_time_limit(3000);

    /**
     * Database master-slave configuration:
     * aSlaveHosts - array of slave hosts: array('localhost', '10.2.3.12')
     */
    $this->aSlaveHosts = null;

    // Control the removal of Setup directory
    $this->blDelSetupDir = true;

    /**
     * Needed for backwards compatibility. Do not change the value of this property.
     *
     * @deprecated since v6.0 (2017-05-15); This property will be removed in the future as the shop will always use UTF-8.
     */
    $this->iUtfMode = 1;
